package com.rocogz.syy.equity.entity.template;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:模版列自定义字典值 </dd>
 * <dd>@date: 2021/10/26</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_issuing_template_column_dict")
public class EquityIssuingTemplateColumnDict  extends IdEntity {

    private static final long serialVersionUID=1L;


    /**
     * 全局编码
     * 帅哥说，发放主体模版导入的数据 对于发券类型字段 存储的是这个code，
     * 之后的名称回显，查询等都是从这个里面来的
     */
    private String code;

    /**
     * 模板主表code
     */
    private String templateCode;

    /**
     * 发放主体code
     */
    private String issuingBodyCode;

    /**
     * 字典配置列，字典code.
     * 本次的columnCode=GRANTCOUPONTYPE(发券类型)
     */
    private String columnCode;

    /**
     * 用户自定义的code,页面上用户可以自己编辑
     */
    private String businessCode;

    /**
     * 用户自定义的name
     */
    private String name;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 启用/停用 OPEN/
     * @see EquityConstants#COMMON_FLAG_OPEN
     * @see EquityConstants#COMMON_FLAG_LOCK
     */
    private String status;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;




}
