package com.rocogz.syy.equity.dto.equity.statistics;

import lombok.Data;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 套餐券/电子油卡券/加油代金券/代驾券 发放统计 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-01-26 11:03:17</dd>
 * <dd>@author：luoyc</dd>
 * </dl>
 */
@Data
public class EquityStatisticsDto {

    /**
     * 日期：yyyy-MM-dd
     */
    private String reportDate;

    /**
     * 发放主体名称
     */
    private String sourceName;

    /**
     * 权益编号
     */
    private String couponCode;

    /**
     * 权益名称
     */
    private String couponName;

    /**
     * 面值
     */
    private BigDecimal faceValue;

    /**
     * 累计发放张数
     */
    private Integer totalGrantQuantity;

    /**
     * 累计领取张数
     */
    private Integer totalReceiveQuantity;

    /**
     * 领取率
     */
    private BigDecimal receiveRate;


    /**
     * 累计发放面值
     */
    private BigDecimal totalGrantFaceValue;

    /**
     * 累计领取面值
     */
    private BigDecimal totalReceiveFaceValue;

}
