package com.rocogz.syy.equity.entity.userCoupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户券使用记录 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-20 22:50:04</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_user_coupon_consume")
public class EquityUserCouponConsume extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 用户券编号
     */
    private String userCouponCode;

    /**
     * 归属套餐券编号
     */
    private String giftCouponCode;

    /**
     *  优惠券编号
     */
    private String couponCode;

    /**
     * 使用平台
     */
    private String platformCode;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 使用金额
     */
    private BigDecimal useAmount;

    /**
     * 可用金额
     */
    private BigDecimal availableAmount;

    /**
     * 活动
     */
    private String activityCode;

    /**
     * 备注
     */
    private String rmk;

    /**
     * 删除标记（留作扩展，如果存在已退还的用户券则此记录标识为Y）
     */
    private String deleteFlag;

    /**
     * 使用时间
     */
    private LocalDateTime createTime;


}
