package com.rocogz.syy.equity.dto.bestow;


import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <dl>
 * <dd>Description: BestowRecordQueryDto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/12/28 16:56</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class BestowRecordQueryDto {
    /**
     * 赠送编码.
     */
    private String code;

    /**
     * 赠送人用户编码
     */
    private String senderUserCode;

    /**
     * 赠送人手机号码.
     */
    private String senderUserMobile;

    /**
     * 赠送人openid.
     */
    private String senderUserOpenid;

    /**
     * 领取人手机号码.
     */
    private String receiverUserMobile;

    /**
     * 领取人姓名.
     */
    private String receiverName;

    /**
     * 领取人手机号码或姓名.
     */
    private String receiverUserMobileOrName;

    /**
     * 赠送状态.
     */
    private String status;

    /**
     * 赠送时间-开始时间.
     */
    private String createTimeStartTime;

    /**
     * 赠送时间-结束时间.
     */
    private String createTimeEndTime;

    /**
     * 赠送类型列表.
     */
    private List<String> typeList;

    /**
     * 业务类型列表.
     */
    private List<String> serviceTypeList;

    /**
     * 分页-页数.
     */
    private Integer page;

    /**
     * 分页-页大小.
     */
    private Integer limit;

    /**
     * 是否查询明细.
     */
    private Boolean needItem = false;

    /**
     * miniAppid
     */
    private String miniAppid;
}
