package com.rocogz.syy.equity.entity.driver;


import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2021/2/1 11:2</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@TableName("equity_designated_driver_record")
public class DesignatedDriverRecord extends IdEntity {


    /**
     * 权益编号
     */
    private String powerNo;

    /**
     * 订单总金额
     */
    private BigDecimal income;

    /**
     * 用户下单纬度 百度坐标
     */
    private BigDecimal startLat;

    /**
     * 用户下单经度 百度坐标
     */
    private BigDecimal startLng;

    /**
     * 取消原因（订单取消才会有值）
     */
    private String cancelDesc;

    /**
     * 订单里程
     */
    private BigDecimal distance;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 用户出发地
     */
    private String locationStart;

    /**
     * 目的地
     */
    private String locationEnd;

    /**
     * 预约订单号
     */
    private String bookingId;

    /**
     * 用户实际下车纬度
     */
    private BigDecimal endLat;

    /**
     * 用户实际下车经度
     */
    private BigDecimal endLng;

    /**
     * 处理标记 0未处理 1已处理
     */
    private String driverId;

    /**
     * 下单人手机号
     */
    private String phone;

    /**
     * 订单实收金额
     */
    private BigDecimal price;

    /**
     * 下单联系人手机号
     */
    private String contactPhone;

    /**
     * 司机接单时间
     */
    private LocalDateTime callTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}