package com.rocogz.syy.equity.entity.issuingBody;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * <dl>
 * <dd>Description: 发放主体优惠券配置表 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-07-22 14:08:05</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_issuing_body_coupon_config")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityIssuingBodyCouponConfig extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 来源（主体）编号
     */
    private String sourceCode;

    /**
     * 机构编号
     */
    private String orgCode;

    /**
     * 优惠券编号:*为对应此机构（主体）下所有券都验证
     */
    private String couponCode;

    /**
     * 启用状态:OPEN,LOCK
     */
    private String status;


}
