package com.rocogz.syy.equity.entity.userCoupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户券用户信息表 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-18 12:59:32</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_user_coupon_user_info")
public class EquityUserCouponUserInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 用户券编号
     */
    private String userCouponCode;

    /**
     * 归属套餐券编号
     */
    private String giftCouponCode;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 会员编号
     */
    private String userCode;

    /**
     * 领取参数：依据领取规则根据当前券的发放信息换算
     */
    private String receiveParam;

    /**
     * 使用规则编码
     */
    private String useRuleCode;

    /**
     * 姓名
     */
    private String name;

    /**
     * 微信昵称
     */
    @TableField(exist = false)
    private String wxNickName;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 真实手机号
     */
    private String realMobile;

    /**
     * 微信openid
     */
    private String openId;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码
     */
    private String idCard;

    /**
     * 证件号码明文
     */
    private String idCardExplicit;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 车架号
     */
    private String vinNo;

    /**
     * 承保机构
     */
    private String policyOrgCode;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
