package com.rocogz.syy.equity.entity.coupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 基准券与第三方权益关系 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-12-19 09:45:31</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_coupon_third_equity_rel")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityCouponThirdEquityRel extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 基准券编号
     */
    private String couponCode;

    /**
     * 第三方权益编号
     */
    private String thirdEquityCode;


}
