package com.rocogz.syy.equity.entity.rule;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 领取验证规则明细实体
 * </p>
 *
 * @author yifenrui
 * @since 2021-03-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "equity_receive_rule_details")
public class EquityReceiveRuleDetails extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 规则主表编号
     */
    private String receiveRuleCode;

    /**
     * 规则编号，规则字典code
     */
    private String ruleCode;

    /**
     * 验证值
     */
    private String verityValue;


    /**
     * 规则名称
     */
    @TableField(exist = false)
    private String name;

    /**
     * 备注
     */
    @TableField(exist = false)
    private String description;

    @TableField(exist = false)
    private String status;

}
