package com.rocogz.syy.equity.entity.userCoupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.equity.entity.coupon.EquityCouponInfo;
import com.rocogz.syy.equity.entity.oilCardUserCoupon.EquityOilCardUserCoupon;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户券基本信息 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-06 12:59:51</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_user_coupon_info")
public class EquityUserCouponInfo extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编号
     */
    private String code;

    /**
     * 平台商品编号
     */
    private String platformProductCode;

    /**
     * 套餐平台产品编号
     */
    private String comboPlatformProductCode;

    /**
     * 代理商产品编号
     */
    private String agentProductCode;

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 发放规则
     */
    private String grantRuleCode;

    /**
     * 领取规则
     */
    private String receiveRuleCode;

    /**
     * 归属套餐券编号
     */
    private String giftCouponCode;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 优惠券类型编号
     */
    private String couponTypeCode;

    /**
     *
     */
    private String exchangeCode;

    /**
     * 兑换码
     */
    private String redeemCode;

    /**
     * 第三方编号（可以是订单编号可以是其他编号）
     */
    private String thirdCode;

    /**
     * 第三方金额
     */
    private BigDecimal thirdAmount;

    /**
     * 发券性质：BUSINESS_VERIFY:业务验证，NORMAL：正常发券
     */
    private String nature;

    /**
     * 状态：未生效、未使用、已使用、已过期、已冻结、已作废
     */
    private String status;

    /**
     * 是否领取验证：Y-是，N-否
     */
    private String isReceiveVerify;

    /**
     * 领取验证结果：Y-通过，N-不通过
     */
    private String receiveVerifyResult;

    /**
     * 领取验证时间
     */
    private LocalDateTime receiveVerifyTime;

    /**
     * 点击状态：Y-已点击，N-未点击
     */
    private String clickStatus;

    /**
     * 点击时间
     */
    private LocalDateTime clickTime;

    /**
     * 领取标志：Y-已领取，N-未领取
     */
    private String receiveFlag;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 发放月份
     */
    private String grantMonth;

    /**
     * 创建人手机号
     */
    private String createUserMobile;

    /**
     * 优惠券信息
     */
    @TableField(exist = false)
    private EquityCouponInfo couponInfo;

    /**
     * 用户券会员信息
     */
    @TableField(exist = false)
    private EquityUserCouponUserInfo userInfo;

    /**
     * 用户券使用信息
     */
    @TableField(exist = false)
    private EquityUserCouponUseInfo useInfo;

    /**
     * 用户券投放信息
     */
    @TableField(exist = false)
    private EquityUserCouponLaunchInfo launchInfo;

    /**
     * 用户券金额信息
     */
    @TableField(exist = false)
    private EquityUserCouponOilCashInfo cashInfo;

    /**
     * 用户券积分信息
     */
    @TableField(exist = false)
    private EquityOilCardUserCoupon pointInfo;

}
