package com.rocogz.syy.equity.dto.equity.userCoupon;

import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description: 平安领券查询待领取用户券的请求参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-03-10 16:00:56</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class UserCouponRecieveSearchParamPADto {

    /**
     * 姓名
     */
    @NotNull(message = "姓名" + EquityConstants.EMPTY_MESSAGE)
    private String name;

    /**
     * 手机号
     */
    @NotNull(message = "手机号" + EquityConstants.EMPTY_MESSAGE)
    private String mobile;


    /**
     * 车牌号
     */
    @NotNull(message = "车牌号" + EquityConstants.EMPTY_MESSAGE)
    private String licenseNo;

    /**
     * 小程序id
     */
    @NotNull(message = "小程序id" + EquityConstants.EMPTY_MESSAGE)
    private String miniAppid;

    /**
     * 绑定手机号
     */
    @NotNull(message = "绑定手机号" + EquityConstants.EMPTY_MESSAGE)
    private String bindMobile;

    /**
     * 证件号码
     */
    private String idCard;

}
