package com.rocogz.syy.equity.dto.issuingBody.goodsRule;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:保存请求 </dd>
 * <dd>@date: 2021/12/22</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class EquityIssuingGoodsSendRuleSaveReq {

    /**
     * 发放主体编码
     */
    @NotBlank
    private String issuingBodyCode;

    /**
     * 合作客户Code
     */
    @NotBlank
    private String customerCode;

    /**
     * 合作客户产品编码
     */
    @NotBlank
    private String goodsCode;

    /**
     * 发放额度限制比例,存储的时候转化为小数
     */
    @Min(1)
    @Max(100)
    @NotNull
    private BigDecimal amountRatio;

    /**
     * 状态
     */
    private String status;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
