package com.rocogz.syy.equity.entity.batchDistributionCouponApply;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.EquityConstants;
import com.rocogz.syy.equity.entity.attachment.EquityAttachment;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:权益发放清单撤回 </dd>
 * <dd>@date: 2021/08/11</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_recall_apply")
public class EquityBatchDistributionRecallApply extends IdEntity {
    private static final long serialVersionUID=1L;

    /**
     * 撤回申请单号
     * 增加唯一索引
     */
    private String recallCode;

    /***
     * 要撤回的清单编号
     */
    private String applyDetailCode;

    /**
     * 状态：待审核/审核通过/审核不通过/撤回中/撤回失败/已撤回
     * @see EquityConstants.DictEquityRecallApplyStatus
     */
    private String status;

    /**
     * 撤回原因
     */
    private String recallReason;

    /**
     * 审核人
     */
    private String approveUser;


    /**
     * 审核时间
     */
    private LocalDateTime approveTime;

    /**
     * 审核状态: 待审核/审核通过/审核不通过   推导出来字段存储?
     */
    private String approveStatus;

    /**
     * 审核备注
     */
    private String approveRmk;

    /**
     * 点击开始撤回/重试撤回 按钮的人员
     */
    private String recallSubmitUser;

    /**
     * 点击开始撤回按钮的时间
     */
    private LocalDateTime recallSubmitTime;

    /**
     * 撤回完成时间
     */
    private LocalDateTime recallSuccessTime;

    /**
     * 错误信息
     */
    private String errorDesc;

    /**
     * 最新一次 撤回 结果接收时间
     */
    private LocalDateTime lastRecallTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 权益的附件
     */
    @TableField(exist = false)
    private List<EquityAttachment> attachList;


    /**
     * 审核人手机号
     */
    @TableField(exist = false)
    private String approveUserMobile;

    /**
     * 创建人手机号
     *
     */
    @TableField(exist = false)
    private String createUserMobile;

    /**
     * 执行撤回人手机号
     */
    @TableField(exist = false)
    private String recallSubmitUserMobile;


}
