package com.rocogz.syy.equity.entity.rule;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 方法规则日志实体
 * </p>
 *
 * @author yifenrui
 * @since 2021-03-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "equity_inssuing_rule_log")
public class EquityInssuingRuleLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 主体编号
     */
    private String issuingBodyCode;

    /**
     * 规则主表编号
     */
    private String ruleCode;

    /**
     * 操作项
     */
    private String opType;

    /**
     * 操作内容
     */
    private String opContent;

    /**
     * 操作者
     */
    private String createUser;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;


}
