package com.rocogz.syy.equity.dto.equity.batchDistributionApply.bagent;

import com.rocogz.syy.equity.EquityConstants;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 申请单 现金支付订单Dto
 * @author zhangmin
 * @date 2020/5/31
 */
@Setter @Getter
public class CashPayDto {

    /**
     * 要支付的 申请单号 [必须]
     */
    private String applyNo;

    /**
     * 第三方支付平台的 支付单号或支付交易号 [必须]
     */
    private String payCode;

    /**
     * 支付的现金 金额 [必须]
     */
    private BigDecimal payAmt;

    /**
     * 现金支付方式：是微信支付,还是支付宝支付  [必须]
     * @see EquityConstants.DictEquityApplyPayWay#WEIXIN
     */
    private String payWay;

}
