package com.rocogz.syy.equity.dto.equity.oilCardPointAccount;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 积分发放流水 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-10-14 18:40:45</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class OilCardPointGrantParamDto extends IdEntity {

    /**
     * 业务流水号，外系统传入全局唯一
     */
    private String businessSerialNo;

    /**
     * 业务相关用户号
     */
    private String businessUserCode;

    /**
     * 业务相关用户昵称
     */
    private String businessNickName;

    /**
     * 业务相关用户手机号
     */
    private String businessMobile;

    /**
     * 业务号（可以是订单编号或者其他业务编号）
     */
    private String businessCode;

    /**
     * 业务金额(如果业务号是订单编号此字段为订单金额）
     */
    private BigDecimal businessAmount;

    /**
     * 积分金额
     */
    private BigDecimal pointAmount;

    /**
     * 发放类型：NORMAL:普通发放，PERSON_ORDER:个人订单，TEAM_ORDER：团队订单，TRANSFER：转赠发放， AUTHENTICATION：认证奖励，REGISTER:注册奖励
     */
    private String type;

    /**
     * 积分账户类型：ROCO_POINT:大诚积分账户
     */
    private String pointType;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 发放平台
     */
    private String grantPlatformCode;

    /**
     * 用户号
     */
    private String userCode;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码(明文)
     */
    private String idCardExplicit;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * openId
     */
    private String openId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 承保机构
     */
    private String policyOrgCode;

    /**
     * 描述
     */
    private String description;
}
