package com.rocogz.syy.equity.dto.issuingBody.goodsRule;

import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * <dl>
 * <dd>Description:保存请求 </dd>
 * <dd>@date: 2021/12/22</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class EquityIssuingGoodsSendRuleSaveReq {

    /**
     * 发放主体编码
     */
    @NotBlank
    private String issuingBodyCode;

    /**
     * 合作客户Code
     */
    @NotBlank
    private String customerCode;

    /**
     * 合作客户产品编码
     */
    @NotBlank
    private String goodsCode;

    /**
     * 发放额度限制比例,存储的时候转化为小数
     */
    @Min(1)
    @Max(100)
    private BigDecimal amountRatio;

    /**
     * 金额限制
     */
    private BigDecimal amountLimit;

    /**
     * 类型
     * @see EquityConstants.IssuingGoodsAmountLimitType
     */
    @NotBlank
    private String type;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


    /**
     * 验证
     * @return
     */
    public Response validate(){

        if(Objects.isNull(this.getAmountLimit()) && Objects.isNull(this.getAmountRatio())){
            return Response.failure("比例/额度为空");
        }

        List<String> types = Arrays.asList(EquityConstants.IssuingGoodsAmountLimitType.AMOUNT, EquityConstants.IssuingGoodsAmountLimitType.AMOUNT_RATIO);

        if(!types.contains(this.getType())){
            return Response.failure("类型不正确");
        }

        if(EquityConstants.IssuingGoodsAmountLimitType.AMOUNT.equals(this.getType())){
            if(Objects.isNull(this.getAmountLimit())){
                return Response.failure("请填写限制额度");
            }
            if(this.amountLimit.compareTo(BigDecimal.ZERO)<0){
                return Response.failure("限制额度不能小于0");
            }
        }

        if(EquityConstants.IssuingGoodsAmountLimitType.AMOUNT_RATIO.equals(this.getType())){
            if(Objects.isNull(this.getAmountRatio())){
                return Response.failure("请填写限制比例");
            }
        }

        return Response.succeed();
    }


}
