package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 批量发券申请单手工处理原始数据 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2021-12-30 18:42:27</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_apply_manual")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionApplyManual extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 主体编号
     */
    private String issuingCode;

    /**
     * 权益产品编号
     */
    private String productCode;

    /**
     * 权益产品名称
     */
    private String productName;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 姓名
     */
    private String name;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码
     */
    private String idCard;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 发放数量
     */
    private Integer quantity;

    /**
     * 面值
     */
    private BigDecimal faceValue;

    /**
     * 申请人
     */
    private String createUser;

    /**
     * 申请人手机号
     */
    private String createMobile;

    /**
     * 发放时间
     */
    private LocalDateTime createTime;

    /**
     * 处理状态：Y-已处理，N-未处理
     */
    private String status;


}
