package com.rocogz.syy.equity.dto.equity.batchDistributionApply;

import com.rocogz.syy.equity.entity.template.EquityIssuingTemplateColumnDict;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <dl>
 * <dd>Description: 申请单清单查询参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-04-09 19:08:29</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class BatchDetailParamDto {

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 清单编号
     */
    private String applyDetailCode;

    /**
     * 平台ID
     */
    private String miniAppid;

    /**
     * 发放主体
     */
    private String sourceCode;

    /**
     * 权益编号
     */
    private String couponCode;

    /**
     * 权益名称
     */
    private String couponName;

    /**
     * 权益类型
     */
    private String typeCode;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 姓名
     */
    private String name;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 车架号
     */
    private String vinNo;

    /**
     * 发券类型 查询参数, 页面显示：发券类型
     * @see EquityIssuingTemplateColumnDict#code
     */
    private String grantCouponTypes;

    /**
     * 状态
     */
    private String status;

    /**
     * 账号类型：system-系统账号，platform-主体账号，service-服务商账号，biz-集成商账号
     */
    private String accountType;

    /**
     * 撤回开始日期
     * @description Andy 2021-09-26 10:24:31
     */
    private String recallStartDate;

    /**
     * 撤回结束日期
     * @description Andy 2021-09-26 10:24:31
     */
    private String recallEndDate;

    /**
     * 申请开始日期
     */
    private String applyStartDate;

    /**
     * 申请结束日期
     */
    private String applyEndDate;

    /**
     * 发放月份
     */
    private String grantMonth;

    /**
     * 发放开始日期
     */
    private String grantStartDate;

    /**
     * 发放结束日期
     */
    private String grantEndDate;

    /**
     * 领取开始日期
     */
    private String receiveStartDate;

    /**
     * 领取结束日期
     */
    private String receiveEndDate;

    /**
     * 领取状态：Y-已领取，N-未领取
     */
    private String receiveStatus;

    /**
     * 发券性质：NORMAL-正常发券，BUSINESS_VERIFY：业务验证
     */
    private String nature;

    /**
     * 审核标志：Y-需审核，N-不需审核
     */
    private String approveFlag;

    /**
     * 审核结果：PASS-审核通过，DISAGREE-审核不通过，ALL-所有已审核过的数据
     */
    private String approveResult;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 品牌
     */
    private String brand;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 客户编号
     */
    private String customerCode;

    /**
     * 操作人
     */
    private String operateUser;

    /**
     * 操作人手机号
     */
    private String operateUserMobile;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 续保员
     */
    private String renewalInsurePerson;

    /**
     * 手机号（模糊匹配）
     */
    private String likeMobile;

    /**
     * 排序字段
     */
    private String sortField;

    /**
     * 排序类型  desc,asc
     */
    private String sortType;

    /**
     * 每页记录数
     */
    private Integer limit = 20;

    /**
     * 页码
     */
    private Integer page = 1;


    public List<String>  getGrantCouponTypeList() {
        if(StringUtils.isEmpty(grantCouponTypes)) {
            return null;
        }

        return Arrays.stream(grantCouponTypes.split(","))
                .filter(code->StringUtils.isNotEmpty(code) && !code.equals("null")).collect(Collectors.toList());
    }
}
