package com.rocogz.syy.equity.entity.coupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 优惠券发放礼包 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-12-19 09:45:31</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_coupon_gift_rel")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityCouponGiftRel extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 基准券编号
     */
    private String couponCode;

    /**
     * 发放的基准券
     */
    private String grantCouponCode;

    /**
     * 发放的基准券名称
     */
    @TableField(exist = false)
    private String grantCouponName;

    /**
     * 发放的基准券类型
     */
    private String couponType;

    /**
     * 发放的基准券类型名称
     */
    @TableField(exist = false)
    private String couponTypeName;

    /**
     * 第三方权益编码
     */
    private String thirdEquityCode;

    /**
     * 发放张数
     */
    private Integer quantity;
}
