package com.rocogz.syy.equity.dto.equity.userCoupon;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 用户券列表查询请求参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-04-28 11:08:52</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class UserCouponInfoListParamDto {
    /**
     * 用户券编号
     */
    private String code;
    /**
     * 用户号
     */
    private String userCode;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 权益编号
     */
    private String couponCode;
    /**
     * 权益类型
     */
    private String couponTypeCode;
    /**
     * 活动编号
     */
    private String activityCode;
    /**
     * 状态
     */
    private String status;
    /**
     * 用户券状态，主体专用菜单查看状态
     */
    private String userCouponStatus;

    /**
     * 发放主体编号
     */
    private String sourceCode;
    /**
     * 小程序id
     */
    private String miniAppids;
    /**
     * 领取状态
     */
    private String receiveFlag;
    /**
     * 点击状态
     */
    private String clickStatus;
    /**
     * 领取开始日期
     */
    private String receiveStartDate;
    /**
     * 领取结束日期
     */
    private String receiveEndDate;
    /**
     * 申请单编号
     */
    private String applyNo;
    /**
     * 发券性质
     */
    private String nature;
    /**
     * 申请单清单编号
     */
    private String applyDetailCode;
    /**
     * 团队编号
     */
    private String teamCode;
    /**
     * 代理商编号
     */
    private String agentCode;
    /**
     * 客户编号
     */
    private String customerCode;
    /**
     * 操作用户
     */
    private String operateUser;

    /**
     * 发放开始日期
     */
    private String createStartDate;

    /**
     * 发放结束日期
     */
    private String createEndDate;

    /**
     * 失效开始日期
     */
    private String invalidStartDate;

    /**
     * 失效结束日期
     */
    private String invalidEndDate;

    private String couponName;

    /**
     * 每页记录数
     */
    private Integer limit = 20;

    /**
     * 页码
     */
    private Integer page = 1;

}
