package com.rocogz.syy.equity.dto.equity.template;

import com.rocogz.syy.equity.entity.template.EquityIssuingTemplateColumn;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 发放的模版列
 * @author zhangmin
 */
@Setter
@Getter
@Accessors(chain = true)
@NoArgsConstructor
public class TemplateColumnDto {

    private String columnCode;

    private String columnName;

    private String columnValue;


    /**
     * Y:必填，N非必填
     */
    private String required;

    /**
     * 排序
     */
    private Integer sort;


    /**
     * 该列的下拉选择,如果该列是 主体发券类型下拉框
     */
    private List<DropOption> dropList;

    public static TemplateColumnDto valueOf(EquityIssuingTemplateColumn column) {
        TemplateColumnDto columnDto = new TemplateColumnDto();

        columnDto.setColumnCode(column.getColumnCode())
                .setColumnName(column.getTemplateName())
                .setRequired(column.getRequired())
                .setSort(column.getSort());
        return columnDto;
    }
}
