package com.rocogz.syy.equity.entity.issuingBody;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.equity.EquityConstants;
import com.rocogz.syy.equity.dto.issuingBody.EquityIssuingBodyAssociatedDto;
import com.rocogz.syy.equity.dto.issuingBody.IssuingBodyRoleDto;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 发放主体
 * </p>
 *
 * @author yinshihao
 * @since 2020-04-08
 */
@TableName(value = "equity_issuing_body")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class IssuingBody extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 主体类型(目前分为三种:人保机构 ROCO_ORG, 合作企业 ENTERPRISE, 平台商户 BUSINESS)
     */
    private String type;

    /**
     * 父级主体编码,父级主体编码为0的为顶级主体
     */
    private String pCode;

    /**
     * 主体等级(默认顶级为1级,其子级为2级,以此类推)
     */
    private Integer level;

    /**
     * 主体编码
     */
    private String code;

    /**
     * 主体名称
     */
    private String name;

    /**
     * 关联主体编码 (当主体类型是人保机构时代表机构编码,是合作企业时代表社会信用代码,是平台商户时代表平台商户编码)
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String linkedBodyCode;

    /**
     * 关联主体名称 (当主体类型是人保机构时代表机构名称,是合作企业时代表企业名称,是平台商户时此项为空)
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String linkedBodyName;

    /**
     * 简称(人保机构和合作企业才有)
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String abbreviation;

    /**
     * 说明(只有合作企业才有)
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String description;

    /**
     * 状态(分为OPEN/LOCK)
     */
    private String status;

    /**
     * 小程序appid
     */
    private String miniAppid;

    /**
     * 小程序名称
     */
    @TableField(exist = false)
    private String miniName;

    /**
     * 服务平台名称
     */
    @TableField(exist = false)
    private String servicePlatformName;

    /**
     * 发放主体性质
     * @see EquityConstants.DictEquityIssuingBodyNature#AGENT
     */
    private String whetherCustomer;

    /**
     * 合作客户编码
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String customerCode;

    /**
     * 合作客户简称
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String customerAbbreviation;

    /**
     * 发放主体关联平台专区信息
     */
    @TableField(exist = false)
    private List<EquityIssuingBodyAssociatedDto> associatedDto;

    /**
     * 关联角色id列表
     */
    @TableField(exist = false)
    private List<Integer> roleIdList;

    /**
     * 关联角色列表
     */
    @TableField(exist = false)
    private List<IssuingBodyRoleDto> roleList;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区名称
     */
    private String districtName;

    /**
     * 区编码
     */
    private String districtCode;

    /**
     * 街道名称
     */
    private String streetName;

    /**
     * 街道编码
     */
    private String streetCode;

    /**
     * 详细地址
     */
    private String detailAddress;

    /**
     * 发放主体联系人列表
     */
    @TableField(exist = false)
    private List<EquityIssuingBodyContacts> issuingBodyContacts;


    /**
     * 是否是平台账号
     */
    @TableField(exist = false)
    private String platformUser;


    /**
     * 创建人账号姓名
     */
    @TableField(exist = false)
    private String userName;

    /**
     * 电子券显示的赠送方名称
     */
    private String giverName;

    /**
     * 产品发放模式
     */
    private String productDistributionMode;

    /**
     * 卡券领取信息可见性 Y: 可见, N 不可见
     */
    private String couponReceiveVisible;

    /**
     * 发放主体简称
     */
    private String issuingBodyAbbreviation;

    /**
     * 所属代理商
     */
    private String belongAgent;

    /**
     * 所属代理商名称
     */
    @TableField(exist = false)
    private String belongAgentName;

    /**
     * 所属代理商简称
     */
    @TableField(exist = false)
    private String belongAgentAbbreviation;

    /**
     * 企业类型
     */
    private String enterpriseType;

    /**
     * 业务性质分类
     */
    private String businessNatureClassification ;

    /**
     * 结算单位标记
     */
    private String settlementUnitMark;

    /**
     * 存在结算主体(Y:有,N:没有)
     */
    private String existSettleSubject;

    /**
     * 对应结算主体编码列表
     */
    @TableField(exist = false)
    private List<String> settleSubjectCodeList;

    /**
     * 同级顺序号
     */
    private Integer sort;

    /**
     * 所属结算单位编码
     */
    private String belongSettlementUnit;

    /**
     * 所属结算单位主体
     */
    @TableField(exist = false)
    private IssuingBody belongSettlementUnitBody;

    @TableField(exist = false)
    private int limit;

    @TableField(exist = false)
    private int page;

    @TableField(exist = false)
    List<String> dataPermissions;

    @TableField(exist = false)
    List<String> agentPermissions;

    @TableField(exist = false)
    List<String> customerPermissions;

    /**
     * 小程序发放是否需要审批(Y:需要,N:不需要)
     */
    private String whetherNeedApprove;
}
