package com.rocogz.syy.equity.entity.rule;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;
import lombok.experimental.Accessors;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>
 *  发放主体合作客户产品的发放限制规则
 *
 *  主体控制单项产品的发放比例不能超过设定比例的
 * </dd>
 * <dd>@date: 2021/12/22</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@TableName(value = "equity_issuing_goods_send_rule")
public class EquityIssuingGoodsSendRule extends IdEntity {

    /**
     * 发放主体编码
     */
    private String issuingBodyCode;

    /**
     * 合作客户Code
     */
    private String customerCode;

    /**
     * 合作客户产品编码
     */
    private String goodsCode;

    /**
     * 类型 一个商品只会有一种
     * @see EquityConstants.IssuingGoodsAmountLimitType
     */
    private String type;

    /**
     * 发放额度限制比例 存储的是小数
     */
    private BigDecimal amountRatio;

    /**
     * 发放限制的额度
     */
    private BigDecimal amountLimit;

    /**
     * 创建人id
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
