package com.rocogz.syy.equity.dto.equity.template.label;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;


/**
 * <dl>
 * <dd>Description:保存或更新模版标签 </dd>
 * <dd>@date: 2022/05/24</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class EquityTemplateLabelSaveUpdateReq {
    /**
     * 标签编码
     */
    public String code;
    /**
     * 标签名称
     */
    @NotBlank
    public String name;
    /**
     * 标签说明
     */
    public String introduce;

    /**
     * OPEN 默认展开，LOCK 默认折叠
     */
    @NotBlank
    public String infoShowStatus;

    /**
     * 状态启用/停用 OPEN/LOCK
     */
    @NotBlank
    public String status;


    @NotNull
    public Integer sort;

    /**
     * 操作人
     */
    @NotBlank
    private String operator;

}
