package com.rocogz.syy.equity.dto.equity.userCoupon;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户积分券兑换记录 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-09-04 16:44:36</dd>
 * <dd>@author：Andy</dd>
 * @description Andy 2022-01-05 17:17:03 新增发券性质字段
 * </dl>
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class UserCouponExchangeRecordDto {

    /**
     * 兑换id
     */
    private String exchangeId;

    /**
     * 扣减积分
     */
    private String useAmount;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 用户券编号
     */
    private String userCouponCode;

    /**
     * 总积分
     */
    private String totalAmount;

    /**
     * 业务单号
     */
    private String applyNo;

    /**
     * 清单编号
     */
    private String applyDetailCode;

    /**
     * 发放主体编号
     */
    private String issuingCode;

    /**
     * 发放主体简称
     */
    private String issuingName;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 团队名称（需要在聚合赋值）
     */
    private String teamName;

    /**
     * 发放人
     */
    private String createUser;

    /**
     * 发放人手机号
     */
    private String createMobile;

    /**
     * 发放月份
     */
    private String createMonth;

    /**
     * 发放时间
     */
    private LocalDateTime createTime;

    /**
     * 领取月份
     */
    private String receiveMonth;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 兑换月份
     */
    private String exchangeMonth;

    /**
     * 兑换时间
     */
    private LocalDateTime exchangeTime;

    /**
     * 作废时间
     */
    private LocalDateTime updateTime;

    /**
     * 发券性质
     */
    private String nature;

}
