package com.rocogz.syy.equity.entity.attachment;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:权益的附件 </dd>
 * <dd>@date: 2021/08/11</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_attachment")
public class EquityAttachment extends IdEntity {
    private static final long serialVersionUID=1L;


    /**
     * 目标编码
     */
    private String targetCode;

    /**
     * 目标类型
     */
    private String targetType;

    /**
     * 目标排序号
     */
    private Integer targetSeq;

    /**
     * 上传的文件名
     */
    private String uploadName;

    /**
     * 文件说明
     */
    private String description;

    /**
     * 文件路径
     */
    private String path;

    /**
     * 文件大小
     */
    private Integer fileSize;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
