package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 清单操作日志 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2022-05-16 20:29:24</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_coupon_apply_detail_operate_log")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionCouponApplyDetailOperateLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 清单编号
     */
    private String applyDetailCode;

    /**
     * 操作前状态:（数据字典：BATCH_DISTRIBUTION_DETAIL_ISSUINGBODY_STATUS)
     */
    private String operateStatus;

    /**
     * 操作结果:（数据字典：BATCH_DISTRIBUTION_DETAIL_OPERATE_RESULT）
     */
    private String operateResult;

    /**
     * 操作人
     */
    private String createUser;

    /**
     * 操作人手机号
     */
    private String createUserMobile;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;

}
