package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.google.common.collect.Maps;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * <p>
 * B端礼赠申请单支付记录
 * </p>
 *
 * @author zhangmin
 * @since 2021-05-21
 */
@Setter
@Getter
@Accessors(chain = true)
public class EquityCouponApplyPaymentRecord extends IdEntity {

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 支付流水号
     */
    private String paySncode;

    /**
     * 支付方式：额度支付、微信支付
     *
     * @see EquityConstants.DictEquityApplyPayWay
     */
    private String payWay;

    /**
     * 支付凭证号：如：用户券编号、油卡电子券编号、微信支付流水号
     */
    private String payCredential;

    /**
     * 支付额度：如现金多少，积分多少
     */
    private BigDecimal payAmt;

    /**
     * 剩余未支付额度（支付成功时更新）
     */
    private BigDecimal unpayAmt;

    /**
     * 此次支付状态
     *
     * @see EquityConstants.DictEquityApplyPayStatus
     */
    private String payStatus;

    /**
     * 扩展属性信息
     */
    @TableField("ext_attrs")
    private String extAttrsJson;

    /**
     * 发起支付时间
     */
    private LocalDateTime createTime;

    /**
     * 成功完成支付时间
     */
    private LocalDateTime finishTime;



    private transient Map<String,Object> extAttrData;


    public void putExtAttr(String key,Object value) {
        if(StringUtils.isNotEmpty(key)) {
            if(extAttrData == null) {
                extAttrData = Maps.newHashMap();
            }
            extAttrData.put(key,value);
        }
    }


}
