package com.rocogz.syy.equity.entity.operationLog;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 权益操作日志 entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2021-02-03 20:08:14</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_operation_log")
public class EquityOperationLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编号
     */
    private String code;

    /**
     * 类型：APPLY-申请单
     */
    private String type;

    /**
     * 操作：ADJUSTMENT_NATURE:调整发券性质
     */
    private String operation;

    /**
     * 备注
     */
    private String rmk;

    /**
     * 预留1
     */
    private String rmk1;

    /**
     * 预留2
     */
    private String rmk2;

    /**
     * 预留3
     */
    private String rmk3;

    /**
     * 预留4
     */
    private String rmk4;

    /**
     * 预留5
     */
    private String rmk5;

    /**
     * 操作人
     */
    private String createUser;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;


}
