package com.rocogz.syy.equity.entity.userCoupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户代金券 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-06-19 17:17:34</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_user_coupon_oil_cash_info")
public class EquityUserCouponOilCashInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 用户券编号
     */
    private String userCouponCode;

    /**
     * 归属套餐券编号
     */
    private String giftCouponCode;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 用户券面值
     */
    private BigDecimal faceValue;

    /**
     * 可用金额
     */
    private BigDecimal availableAmount;

    /**
     * 已用金额
     */
    private BigDecimal useAmount;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
