package com.rocogz.syy.equity.dto.equity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.equity.entity.coupon.EquityCashCouponProduct;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 代金券、电子加油券集合 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-07-09 20:43:43</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class OilCashAndOilCardCouponDto {

    /**
     * 用户券编号
      */
    private String code;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 优惠券名称
     */
    private String couponName;

    /**
     * 券类型编码
     */
    private String typeCode;

    /**
     * 兑换码
     */
    private String redeemCode;

    /**
     * 状态
     */
    private String status;

    /**
     * 生效日期
     */
    private LocalDateTime effectiveDate;

    /**
     *  失效日期
     */
    private LocalDateTime invalidDate;

    /**
     * 可用金额
     */
    private String availableAmount;

    /**
     * 订单金额
     */
    private String orderAmount;

    /**
     * 面值
     */
    private BigDecimal faceValue;

    /**
     * 使用限额（最小额度）
     */
    private BigDecimal useLimit;

    /**
     * 使用险恶（最大额度）
     */
    private BigDecimal useLimitMax;

    /**
     * 发放主体名称
     */
    private String sourceName;

    /**
     * 代金券商品
     */
    private List<EquityCashCouponProduct> cashAvailableProduct;

    /**
     * 第三方编码
     */
    private String thirdCode;

    /**
     * 第三方金额
     */
    private BigDecimal thirdAmount;

}
