package com.rocogz.syy.equity.dto.equity.batchDistributionApply.bagent;

import com.rocogz.syy.equity.enumerate.QueryGivenRecordTabType;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @author zhangmin
 * @since 2021-05-21
 * 首页-> B端礼赠订单-> 客户赠送记录查询参数
 */
@Getter
@Setter
@Accessors(chain = true)
public class CustomerGivenRecordSearchParamDto {

    private Integer limit = 10;

    private Integer page = 1;

    /**
     * 申请人用户名
     */
    private String applyUserName;

    /**
     * 发放主体编号
     */
    private List<String> issuingBodyCodeList;

    /**
     * 团队编号
     */
    private List<String> teamCodeList;


    //手机号/车牌号/车架号 关键词
    private String customerMobile;


    private QueryGivenRecordTabType queryTab = QueryGivenRecordTabType.ALL;


    public String getCustomerMobileKeyWord() {
        if (StringUtils.isBlank(customerMobile)) {
            return null;
        }

        return StringUtils.wrap(customerMobile.trim(), "%");
    }

}
