package com.rocogz.syy.equity.dto.equity.recall;


import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Arrays;
import java.util.List;

/**
 * <dl>
 * <dd>Description:撤回的结果请求 </dd>
 * <dd>@date: 2021/08/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class RecallApplyRecallResultReq {
    /**
     * 审核的 撤回申请单
     */
    @NotBlank(message = "请传递撤回单号")
    private String  recallCode;
    /**
     * 撤回结果状态
     */
    @NotBlank(message = "请传递状态")
    private String status;
    /**
     * 描述信息
     */
    private String descInfo;

    /**
     * 检查请求
     * @return
     */
    public Response checkReq() {
        List<String> targetStatus = Arrays.asList(EquityConstants.DictEquityRecallApplyStatus.RECALL_SUCCESS,
                EquityConstants.DictEquityRecallApplyStatus.RECALL_FAIL);
        if (!targetStatus.contains(this.getStatus())) {
            return Response.failure("状态不正确");
        }
        return Response.succeed();
    }

    /**
     * 撤回成功
     * @return
     */
    public Boolean recallSuccess(){
        return  EquityConstants.DictEquityRecallApplyStatus.RECALL_SUCCESS.equals(this.getStatus());
    }


}
