package com.rocogz.syy.equity.dto.equity.statistics;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 代驾券使用统计详情 service</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-02-02 12:11:29</dd>
 * <dd>@author：andy</dd>
 * </dl>
 */
@Data
public class EquityDrivingServicesListDto {

    /**
     *  服务平台
     */
    private String miniAppid;

    /**
     * 服务平台名称
     */
    private String miniAppName;

    /**
     * 编号
     */
    private String code;

    /**
     * 兑换码
     */
    private String redeemCode;

    /**
     * 会员编号
     */
    private String userCode;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 优惠券名称
     */
    private String couponName;

    /**
     * 面值
     */
    private BigDecimal faceValue;

    /**
     * 使用金额
     */
    private BigDecimal useAmount;

    /**
     * 剩余金额
     */
    private BigDecimal surplusAmount;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 使用时间
     */
    private LocalDateTime useTime;

    /**
     * 发放主体编号
     */
    private String sourceCode;

    /**
     * 发放主体名称
     */
    private String sourceName;

    /**
     * 发券性质
     */
    private String nature;
}
