package com.rocogz.syy.equity.dto.issuingBody;

import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 发放主体关联平台专区Dto对象
 * </p>
 *
 * @author luoyc
 * @since 2021-02-07
 */
@Data
public class EquityIssuingBodyAssociatedDto extends UserTimeEntity {

    /**
     * 发放主体Code
     */
    private String bodyCode;

    /**
     * 发放主体类型
     */
    private String type;

    /**
     * key 服务平台appid，value 专区编码
     */
    private Map<String, List<String>> mapList;

    /**
     * 关联服务平台Name
     */
    private String servicePlatformName;

    /**
     * 关联专区Name
     */
    private String prefectureName;

    /**
     * 专区CodeList
     */
    private List<String> prefectureCodeList;

}
