package com.rocogz.syy.equity.entity.batchDistributionCouponApply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.equity.EquityConstants;
import com.rocogz.syy.equity.entity.operationLog.EquityOperationLog;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 批量发券申请单主信息 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-14 21:23:15</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_coupon_apply")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionCouponApply extends UserTimeEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 申请单编码
     */
    private String applyNo;

    /**
     * 申请单类型,即发放渠道
     *
     * @see EquityConstants.DictEquityApplyType
     */
    private String applyType;

    /**
     * 平台码
     */
    private String platformCode;

    /**
     * 投放主体
     */
    private String sourceCode;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 小程序名称
     */
    @TableField(exist = false)
    private String miniAppName;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 团队名称
     */
    @TableField(exist = false)
    private String teamName;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 代理商简称
     */
    @TableField(exist = false)
    private String agentName;

    /**
     * 客户编号
     */
    private String customerCode;

    /**
     * 发放人数
     */
    private Integer totalPerson;

    /**
     * 发放总张数
     */
    private Integer totalQuantity;

    /**
     * 产品发放模式：AFTER_PASSING_DIRECT_DISTRIBUTION-申请通过发放，SYSTEM_CENTRALIZED_DISTRIBUTION-系统集中发放
     */
    private String productDistributionModel;

    /**
     * 扣减时点：领取时扣减：DEDUCTION_ON_COLLECTION， 发放时扣减：DEDUCTION_ON_ISSUE
     */
    private String dedutionTimePoint;

    /**
     * 发券性质：BUSINESS_VERIFY:业务验证，NORMAL：正常发券
     */
    private String nature;

    /**
     * 申请单状态(数据字典：BATCH_DISTRIBUTION_APPLY_STATUS  )
     */
    private String status;

    /**
     * 文件名称
     */
    private String fileName;

    /**
     * 文件路径
     */
    private String filePath;

    /**
     * 备注
     */
    private String rmk;

    /**
     * 处理时间
     */
    private LocalDateTime operateTime;

    /**
     * 短信发送次数
     */
    @TableField(exist = false)
    private Integer messageQuantity;

    /**
     * 发送短信标识
     */
    @TableField(exist = false)
    private boolean sendMessageFlag;

    /**
     * 优惠券名称
     */
    @TableField(exist = false)
    private String couponName;

    /**
     * 发放主体名称(简称)
     */
    @TableField(exist = false)
    private String sourceName;

    /**
     * 发放主体名称(全称)
     */
    @TableField(exist = false)
    private String sourceFullName;


    /**
     * B端礼赠申请单金额信息
     */
    @TableField(exist = false)
    private EquityCouponApplyOrder couponApplyOrder;

    /**
     * 批量发券申请单清单
     */
    @TableField(exist = false)
    private List<EquityBatchDistributionCouponApplyDetail> batchDistributionDetailList;

    /**
     * 优惠券发放结果记录
     */
    @TableField(exist = false)
    private List<EquityBatchDistributionCouponResultRecord> couponResultRecordList;

    /**
     * 操作日志
     */
    @TableField(exist = false)
    private EquityOperationLog operationLog;

    /**
     * 申请人手机号
     */
    private String createUserMobile;

    /**
     * 发放总面额
     */
    @TableField(exist = false)
    private BigDecimal totalAmount;
}
