package com.rocogz.syy.equity.entity.rule;

import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
@TableName("equity_use_rule")
public class EquityUseRule extends IdEntity {

    private static final long serialVersionUID = 371402856041422198L;

    /**
    * 编号
    */
    private String code;
    
    /**
    * 发放主体编号
    */
    private String issuingBodyCode;
    
    /**
    * 产品编号
    */
    private String productCode;
    
    /**
    * 规则编号
    */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String ruleCode;
    
    /**
    * 状态
    */
    private String status;
    
    /**
    * 创建人
    */
    private String createUser;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 更新人
    */
    private String updateUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
}