package com.rocogz.syy.equity.entity.oilCardUserCoupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * <dl>
 * <dd>Description: 大诚电子加油券-积分转赠领取记录表 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-08-24 10:40:15</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_oil_card_transfer_receive_record")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityOilCardTransferReceiveRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 转赠编号(发起转赠的编号)
     */
    @NotNull
    private String transferCode;

    /**
     * 金额(积分）
     */
    @NotNull
    private BigDecimal amount;

    /**
     * 新用户券编号
     */
    private String userCouponCode;

    /**
     * 领取人会员号
     */
    private String userCode;

    /**
     * 领取人手机号
     */
    @NotNull
    private String mobile;

    /**
     * 领取人openId
     */
    private String openId;

    /**
     * 证件类型
     */
    @TableField(exist = false)
    private String idType;

    /**
     * 证件号码（明文）
     */
    @TableField(exist = false)
    private String idCardExplicit;

    /**
     * 积分账户类型
     */
    @NotNull
    private String pointType;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 油卡订单编号
     */
    @TableField(exist = false)
    private String oilCardCode;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
