package com.rocogz.syy.equity.dto.equity.oilCardUserCoupon;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 积分提现参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2021-11-11 14:20:19</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@Accessors(chain = true)
public class PointCashExtractParamDto implements Serializable {

    /**
     * openId
     */
    @NotNull(message = "openId" + EquityConstants.EMPTY_MESSAGE)
    private String openId;

    /**
     * 订单号
     */
    @NotNull(message = "订单号" + EquityConstants.EMPTY_MESSAGE)
    private String orderCode;

    /**
     * 金额
     */
    @NotNull(message = "金额" + EquityConstants.EMPTY_MESSAGE)
    private BigDecimal amount;

    /**
     * 积分类型
     */
    @NotNull(message = "积分类型" + EquityConstants.EMPTY_MESSAGE)
    private String pointType;

    /**
     * 积分使用说明
     */
    private String description;

    /**
     * 主体编号
     */
    private String sourceCode;

    /**
     * 证件号码
     */
    private String idCardExplicit;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 使用规则编码，竖线分割如：NAME|PHONENUMBER|CARNUMBER
     */
    private String useRuleCode;

    /**
     * 是否积分提现:true-是，false-否
     */
    private boolean isWithdrawals;

}
