package com.rocogz.syy.equity.entity.rule;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;

import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *  方法规则实体
 * </p>
 *
 * @author yifenrui
 * @since 2021-03-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "equity_inssuing_rule")
public class EquityInssuingRule extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编码
     */
    private String code;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 发放主体名称
     */
    @TableField(exist = false)
    private String issuingBodyName;

    /**
     * 生效方式
     */
    private String effectiveType;

    /**
     *  领取XX天生效
     */
    private String effectiveDate;

    /**
     * 失效方式
     */
    private String invalidType;

    /**
     *
     领取XX天失效
     */
    private String invalidDate;

    /**
     *
     状态 启用OPEN,  停用LOCK
     */
    private String status;

}
