package com.rocogz.syy.equity.entity.smsMerge;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 待发送短信合并 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2022-05-11 13:02:42</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_pending_send_sms_merge")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityPendingSendSmsMerge extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 短信模板编号
     */
    private String smsModelCode;

    /**
     * 发送人
     */
    private String sendCode;

    /**
     * 主体编号
     */
    private String sourceCode;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 目标用户手机号
     */
    private String mobile;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码
     */
    private String idCardExplicit;

    /**
     * 小程序id
     */
    private String miniAppid;

    /**
     * 礼包名称
     */
    private String giftName;

    /**
     * 面值
     */
    private BigDecimal faceValue;

    /**
     * 上级业务编号
     */
    private String parentBizCode;

    /**
     * 业务编号(批次号)
     */
    private String bizCode;

    /**
     * 领取截止日期
     */
    private LocalDate invalidDate;

    /**
     * 预计短信发送时间
     */
    private LocalDateTime sendTime;

    /**
     * 执行状态：PENDING-待执行，SUCCESS-已执行
     */
    private String status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
