/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.equity.dto.issuingBody.goodsRule;

import com.rocogz.syy.common.response.Response;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;

public class EquityIssuingGoodsSendRuleSaveReq {
    @NotBlank
    private String issuingBodyCode;
    @NotBlank
    private String customerCode;
    @NotBlank
    private String goodsCode;
    @Min(value=1L)
    @Max(value=100L)
    private @Min(value=1L) @Max(value=100L) BigDecimal amountRatio;
    private BigDecimal amountLimit;
    @NotBlank
    private String type;
    private String updateUser;
    private LocalDateTime updateTime;

    public Response validate() {
        if (Objects.isNull(this.getAmountLimit()) && Objects.isNull(this.getAmountRatio())) {
            return Response.failure((String)"\u6bd4\u4f8b/\u989d\u5ea6\u4e3a\u7a7a");
        }
        List<String> types = Arrays.asList("AMOUNT", "AMOUNT_RATIO");
        if (!types.contains(this.getType())) {
            return Response.failure((String)"\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if ("AMOUNT".equals(this.getType())) {
            if (Objects.isNull(this.getAmountLimit())) {
                return Response.failure((String)"\u8bf7\u586b\u5199\u9650\u5236\u989d\u5ea6");
            }
            if (this.amountLimit.compareTo(BigDecimal.ZERO) < 0) {
                return Response.failure((String)"\u9650\u5236\u989d\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
            }
        }
        if ("AMOUNT_RATIO".equals(this.getType()) && Objects.isNull(this.getAmountRatio())) {
            return Response.failure((String)"\u8bf7\u586b\u5199\u9650\u5236\u6bd4\u4f8b");
        }
        return Response.succeed();
    }

    public String getIssuingBodyCode() {
        return this.issuingBodyCode;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public String getGoodsCode() {
        return this.goodsCode;
    }

    public BigDecimal getAmountRatio() {
        return this.amountRatio;
    }

    public BigDecimal getAmountLimit() {
        return this.amountLimit;
    }

    public String getType() {
        return this.type;
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    public EquityIssuingGoodsSendRuleSaveReq setIssuingBodyCode(String issuingBodyCode) {
        this.issuingBodyCode = issuingBodyCode;
        return this;
    }

    public EquityIssuingGoodsSendRuleSaveReq setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
        return this;
    }

    public EquityIssuingGoodsSendRuleSaveReq setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
        return this;
    }

    public EquityIssuingGoodsSendRuleSaveReq setAmountRatio(BigDecimal amountRatio) {
        this.amountRatio = amountRatio;
        return this;
    }

    public EquityIssuingGoodsSendRuleSaveReq setAmountLimit(BigDecimal amountLimit) {
        this.amountLimit = amountLimit;
        return this;
    }

    public EquityIssuingGoodsSendRuleSaveReq setType(String type) {
        this.type = type;
        return this;
    }

    public EquityIssuingGoodsSendRuleSaveReq setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
        return this;
    }

    public EquityIssuingGoodsSendRuleSaveReq setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EquityIssuingGoodsSendRuleSaveReq)) {
            return false;
        }
        EquityIssuingGoodsSendRuleSaveReq other = (EquityIssuingGoodsSendRuleSaveReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$issuingBodyCode = this.getIssuingBodyCode();
        String other$issuingBodyCode = other.getIssuingBodyCode();
        if (this$issuingBodyCode == null ? other$issuingBodyCode != null : !this$issuingBodyCode.equals(other$issuingBodyCode)) {
            return false;
        }
        String this$customerCode = this.getCustomerCode();
        String other$customerCode = other.getCustomerCode();
        if (this$customerCode == null ? other$customerCode != null : !this$customerCode.equals(other$customerCode)) {
            return false;
        }
        String this$goodsCode = this.getGoodsCode();
        String other$goodsCode = other.getGoodsCode();
        if (this$goodsCode == null ? other$goodsCode != null : !this$goodsCode.equals(other$goodsCode)) {
            return false;
        }
        BigDecimal this$amountRatio = this.getAmountRatio();
        BigDecimal other$amountRatio = other.getAmountRatio();
        if (this$amountRatio == null ? other$amountRatio != null : !((Object)this$amountRatio).equals(other$amountRatio)) {
            return false;
        }
        BigDecimal this$amountLimit = this.getAmountLimit();
        BigDecimal other$amountLimit = other.getAmountLimit();
        if (this$amountLimit == null ? other$amountLimit != null : !((Object)this$amountLimit).equals(other$amountLimit)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$updateUser = this.getUpdateUser();
        String other$updateUser = other.getUpdateUser();
        if (this$updateUser == null ? other$updateUser != null : !this$updateUser.equals(other$updateUser)) {
            return false;
        }
        LocalDateTime this$updateTime = this.getUpdateTime();
        LocalDateTime other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EquityIssuingGoodsSendRuleSaveReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $issuingBodyCode = this.getIssuingBodyCode();
        result = result * 59 + ($issuingBodyCode == null ? 43 : $issuingBodyCode.hashCode());
        String $customerCode = this.getCustomerCode();
        result = result * 59 + ($customerCode == null ? 43 : $customerCode.hashCode());
        String $goodsCode = this.getGoodsCode();
        result = result * 59 + ($goodsCode == null ? 43 : $goodsCode.hashCode());
        BigDecimal $amountRatio = this.getAmountRatio();
        result = result * 59 + ($amountRatio == null ? 43 : ((Object)$amountRatio).hashCode());
        BigDecimal $amountLimit = this.getAmountLimit();
        result = result * 59 + ($amountLimit == null ? 43 : ((Object)$amountLimit).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $updateUser = this.getUpdateUser();
        result = result * 59 + ($updateUser == null ? 43 : $updateUser.hashCode());
        LocalDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    public String toString() {
        return "EquityIssuingGoodsSendRuleSaveReq(issuingBodyCode=" + this.getIssuingBodyCode() + ", customerCode=" + this.getCustomerCode() + ", goodsCode=" + this.getGoodsCode() + ", amountRatio=" + this.getAmountRatio() + ", amountLimit=" + this.getAmountLimit() + ", type=" + this.getType() + ", updateUser=" + this.getUpdateUser() + ", updateTime=" + this.getUpdateTime() + ")";
    }
}

