package com.rocogz.syy.equity.dto.datapermission;

import com.rocogz.syy.equity.dto.tree.DtreeCheckArr;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * <dl>
 * <dd>Description:数据权限使用的树,有点特殊会有断层,断层的就当个父亲吧 </dd>
 * <dd>@date: 2021/06/04</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Getter
@Setter
public class DPIssuingBodyTreeDto {

    public DPIssuingBodyTreeDto() {
        spread=true;
    }

    /**
     * 可以认为就是code和数据权限中的data_type的组合
     */
    private String id;
    /**
     * 级别
     */
    private Integer level;
    /**
     * 标题
     */
    private String title;

    /**
     * 是否展开
     */
    private Boolean spread;

    /**
     * 节点的状态状态，看是否启用，前台没启用的会变颜色
     */
    private String status;

    /**
     * 孩子
     */
    private List<DPIssuingBodyTreeDto> children;

    /**
     * Dtree必须的 如何是
     */
    private DtreeCheckArrNew checkArr = new DtreeCheckArrNew();

    /**
     * 团队的Code
     */
    private String code;
    /**
     * 团队所属的数据权限类型
     */
    private String dataType;


}
