package com.rocogz.syy.equity.dto.equity.batchDistributionApply;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户券短信发放记录查询 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-02-23 16:46:49</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class UserCouponSendMessageRecordDto extends IdEntity {

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 申请单编号
     */
    private String idType;

    /**
     * 发放次数
     */
    private String idCard;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 优惠券名称
     */
    private String couponName;

    /**
     * 优惠券类型
     */
    private String couponTypeCode;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 生效日期
     */
    private LocalDate effectiveDate;

    /**
     * 失效日期
     */
    private LocalDate invalidDate;

    /**
     * 发放张数
     */
    private Integer quantity;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 姓名
     */
    private String name;

    /**
     * 领取状态
     */
    private String receiveStatus;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 短信发送时间
     */
    private LocalDateTime messageTime;

    /**
     * 本次短信距上次短信间隔
     */
    private String intevalBefore;

}
