package com.rocogz.syy.equity.dto.equity.recall;

import com.rocogz.syy.equity.entity.template.EquityIssuingTemplateColumnDict;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:这家伙很懒 </dd>
 * <dd>@date: 2021/08/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode()
@Accessors(chain = true)
public class RecallApplySearchReqResp {
    /**
     * 撤回申请单号
     */
    private String recallCode;
    /**
     * 申请单清单编号
     */
    private String applyDetailCode;
    /**
     * 代理商编号（服务商编号）
     */
    private String agentCode;
    /**
     * 代理商名称（服务商名称）
     */
    private String agentName;
    /**
     * 发放主体
     */
    private String sourceCode;
    /**
     * 发放主体名称
     */
    private String sourceName;
    /**
     * 团队编号
     */
    private String teamCode;
    /**
     * 团队名称
     */
    private String teamName;
    /**
     * 客户手机号
     */
    private String mobile;
    /**
     * 优惠券编号
     */
    private String couponCode;
    /**
     * 权益名称
     */
    private String couponName;
    /**
     * 权益类型编号
     */
    private String couponTypeCode;
    /**
     * 权益类型名称
     */
    private String couponTypeName;
    /**
     * 权益总面值， detail.quantity * detail.unit_face_value
     */
    private BigDecimal totalFaceValue;
    /**
     * 单位面值
     */
    private BigDecimal unitFaceValue;

    /**
     * 发放数量 detail.quantity
     */
    private Integer quantity;
    /**
     * 发券性质
     */
    private String nature;
    /**
     * 发券性质名称
     */
    private String natureName;

    /**
     * 领取状态
     */
    private String receiveStatus;

    /**
     * 领取状态名称
     */
    private String receiveStatusName;

    /**
     * 发放业务号，也就是批量发券的申请单号
     */
    private String applyNo;

    /**
     * 领取平台
     */
    private String miniAppid;

    /**
     * 客户领取平台
     */
    private String miniAppidName;

    /**
     * 发放申请人 对应的是apply中的CreateUser
     */
    private String grantApplyUser;

    /**
     * 发放人手机号，也是发放申请人的手机号
     */
    private String grantApplyUserMobile;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 撤回申请人
     */
    private String recallApplyUser;

    /**
     * 撤回人手机号，撤回申请创建人账号手机号
     */
    private String recallApplyUserMobile;

    /**
     * 撤回申请时间
     */
    private LocalDateTime recallApplyTime;

    /**
     * 审核人
     */
    private String approveUser;

    /**
     * 审核人手机号
     */
    private String approveUserMobile;

    /**
     * 审核
     */
    private String approveStatus;

    /**
     * 审核时间
     */
    private LocalDateTime approveTime;

    /**
     * 最后次撤回执行人
     */
    private String recallSubmitUser;

    /**
     * 最后次撤回执行人手机号
     */
    private String recallSubmitUserMobile;

    /**
     * 点击开始撤回按钮的时间
     */
    private LocalDateTime recallSubmitTime;

    /**
     * 撤回成功时间
     */
    private LocalDateTime recallSuccessTime;

    /**
     * 撤回申请状态 code
     */
    private String status;

    /**
     * 撤回申请状态名称
     */
    private String statusName;

    /**
     * 备付金/额度退款状态
     */
    private String quotaCoverRefundStatus;

    /**
     * 备付金/额度退款状态名称
     */
    private String quotaCoverRefundStatusName;

    /**
     * 最后次的撤回时间
     */
    private LocalDateTime lastRecallTime;

    /**
     * 错误描述
     */
    private String errorDesc;

    /**
     * 车架号
     */
    private String vinNo;

    /**
     * 发券类型（是发券模版中有一列，这个是用户自己填写的）
     * @see EquityIssuingTemplateColumnDict#code
     */
    private String grantCouponType;

    /**
     * 发券类型（是发券模版中有一列，这个是用户自己填写的名字）
     * @see EquityIssuingTemplateColumnDict#name
     */
    private String grantCouponTypeLabel;

}
