package com.rocogz.syy.equity.entity.issuingBody;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 主体工作流节点配置明细
 * </p>
 *
 * @author 陈煜敏
 * @since 2022-12-16
 */
@TableName(value = "equity_issuing_body_node_base_detail")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
@Accessors(chain = true)
public class IssuingBodyNodeBaseDetail extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 节点编号
     */
    private String nodeCode;

    /**
     * 审批人
     */
    private String approveUser;

    /**
     * 审批人姓名
     */
    private String approveName;

    /**
     * 审批人手机号
     */
    private String approveMobile;

    /**
     * 审批人所属主体编号
     */
    private String approveUserIssuingBodyCode;

    /**
     * 审批人所属主体名称
     */
    private String approveUserIssuingBodyName;

}
