package com.rocogz.syy.equity.entity.template;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 
 * </p>
 *
 * @author yifenrui
 * @since 2021-03-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_issuing_template")
public class EquityIssuingTemplate extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编码
     */
    private String code;

    /**
     * 主体编码
     */
    private String issuingBodyCode;

    /**
     * 主体名称
     */
    @TableField(exist = false)
    private String issuingBodyName;

    /**
     * 模板类型，COMMON 通用, CUSTOM 定制
     */
    private String templateType;

    /**
     * 发放附件上传：
     * 仅仅针对：后台单客户发放 和 小程序发放
     * Y/N  默认保存的时候N
     * @see EquityConstants#COMMON_FLAG_Y
     */
    private String issuingAttachUpload;

    /**
     * 附件是否必填
     * Y/N  默认保存的时候N
     * @see EquityConstants#COMMON_FLAG_Y
     */
    private String issuingAttachRequired;

    /**
     * 模板名称
     */
    private String templateName;

    /**
     * 模板阿里云路径
     */
    private String templatePath;


    /**
     * 模板列
     */
    @TableField(exist = false)
    private List<EquityIssuingTemplateColumn> equityIssuingTemplateColumns;

    /**
     * 公共模板列/日志记录比较时之前的日志
     */
    @TableField(exist = false)
    private List<EquityIssuingTemplateColumn> commonColumns;



}
