package com.rocogz.syy.equity.entity.userCoupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.entity.issuingBody.IssuingBody;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 用户券投放信息 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-18 12:59:32</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_user_coupon_launch_info")
public class EquityUserCouponLaunchInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请单编号
     */
    private String applyNo;

    /**
     * 申请单清单编号
     */
    private String applyDetailCode;

    /**
     * 明细订单编号
     */
    private String orderItemCode;

    /**
     * 套餐明细订单编号
     */
    private String grantOrderCode;

    /**
     * 用户券编号
     */
    private String userCouponCode;

    /**
     * 归属套餐券编号
     */
    private String giftCouponCode;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 发放平台：爽YY、大诚权益平台、第三方平台
     */
    private String platformCode;

    /**
     * 发放来源（主体）编号
     */
    private String sourceCode;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 小程序名称
     */
    @TableField(exist = false)
    private String miniAppidName;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 团队名称
     */
    @TableField(exist = false)
    private String teamName;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 客户编号
     */
    private String customerCode;

    /**
     * 发放方式：批量名单、接口调用、个人领取
     */
    private String grantModel;

    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 活动名称
     */
    @TableField(exist = false)
    private String activityName;

    /**
     * 投放主体
     */
    @TableField(exist = false)
    private IssuingBody issuingBody;

}
