package com.rocogz.syy.equity.dto.equity.batchDistributionApply.bagent;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhangmin
 * @since 2021-05-21
 * B端赠送 创建申请单
 */
@Getter
@Setter
@Accessors(chain = true)
public class CreateApplyOrderResultDto {

    /**
     * 创建出来的申请单号
     */
    private String applyNo;

    private String applyType;

    /**
     * 此申请单包括的清单编号列表
     */
    private List<ApplyDetailItem> applyItemList;

    /**
     * Andy 2023-01-07 15:32:03 增加发放数量
     */
    @Setter @Getter @NoArgsConstructor  @AllArgsConstructor
    public static final class ApplyDetailItem {
        private String applyDetailCode;

        private BigDecimal allocatedQuota;

        private Integer quantity;
    }

    public void addApplyItem(ApplyDetailItem detailItem) {
        if (applyItemList == null) {
            applyItemList = Lists.newArrayList();
        }
        applyItemList.add(detailItem);
    }

}
